-- new script file
function OnAfterSceneLoaded(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    
    if not self.loaded then
      self.counted = false
    end
    
    self.startUnitInc:LinkToTarget("startArmyCount")
    self.killUnitDec:LinkToTarget("armyKillDec")
  end
  
  if not self.counted then
    self.counted = true
    self.startUnitInc:TriggerAllTargets()
  end  
end

function OnBeforeDeath(self)
  self.killUnitDec:TriggerAllTargets()
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
    self.counted = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.counted)
  end
end

function CreateTriggerSources(self)
  self:AddTriggerSource("startUnitInc")
  self:AddTriggerSource("killUnitDec")
end
